---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：97-Code Profiler

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特になし。

## 2) 参照した情報（Evidence一覧）

- E-01: `connector/profiler/src/main/scala/org/apache/spark/profiler/ProfilerPlugin.scala`
- E-02: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala`
- E-03: `connector/profiler/src/main/scala/org/apache/spark/profiler/package.scala`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProfilerPluginがSparkPluginを実装 | E-01 (line 32-36) | ○ |
| C-02 | ProfilerDriverPlugin.initでドライバープロファイリング開始 | E-01 (line 45-56) | ○ |
| C-03 | PROFILER_DRIVER_ENABLED設定確認 | E-01 (line 48), E-03 (line 25-30) | ○ |
| C-04 | ProfilerExecutorPlugin.initでサンプリング判定 | E-01 (line 75-89) | ○ |
| C-05 | サンプリング計算: rand.nextInt(100)*0.01 < fraction | E-01 (line 81) | ○ |
| C-06 | PROFILER_EXECUTOR_FRACTION デフォルト0.1 | E-03 (line 39-46) | ○ |
| C-07 | profilerOptionsのデフォルト値 | E-03 (line 63-68) | ○ |
| C-08 | DFS書き込み間隔のデフォルト30秒 | E-03 (line 70-76) | ○ |
| C-09 | SparkAsyncProfilerのstart/stop/dump/resumeコマンド | E-02 (line 54-57) | ○ |
| C-10 | ドライバーファイル名: profile-driver.jfr | E-02 (line 48-52) | ○ |
| C-11 | PROFILER_FOLDER_PERMISSIONS = 770 | E-02 (line 59) | ○ |
| C-12 | PROFILER_FILE_PERMISSIONS = 660 | E-02 (line 60) | ○ |
| C-13 | UPLOAD_SIZE = 8MB | E-02 (line 61) | ○ |
| C-14 | AsyncProfilerLoader.isSupported/load() | E-02 (line 71-78) | ○ |
| C-15 | startWriting: ScheduledExecutorServiceで定期実行 | E-02 (line 116-144) | ○ |
| C-16 | writeChunk: stop→dump→resume→read→write | E-02 (line 146-197) | ○ |
| C-17 | finishWriting: shutdown→awaitTermination→writeChunk(true) | E-02 (line 199-217) | ○ |
| C-18 | appId待機ループ | E-02 (line 152-155) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。Code Profilerモジュールの全ソースコード（3ファイル）を完全に確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み
- 0: 低リスク - 設定パラメータのデフォルト値はpackage.scalaで確認済み
- 0: 低リスク - DFS書き込みの処理フローはSparkAsyncProfiler.scalaで行番号付きで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] writeChunk()のstop→dump→resume間のイベント欠落が許容範囲内か確認
- [ ] サンプリング判定の計算ロジック（rand.nextInt(100) * 0.01）の精度を確認
- [ ] 異常終了時のリソースクリーンアップが適切か確認
